<?php
$host = "localhost";
$user = "kvueikjf_att_user";
$pass = "Mmohammad59!!!";
$dbname = "kvueikjf_attendance_db";

date_default_timezone_set("Asia/Tehran");
require_once 'jdf.php';
require_once 'db.php';

function toJalali($dateTime) {
    try {
        $ts = strtotime($dateTime);
        return jdate("Y/m/d H:i", $ts, '', '', 'fa');
    } catch (Exception $e) {
        return "-";
    }
}

function hoursDiff($start, $end) {
    $start_ts = strtotime($start);
    $end_ts = strtotime($end);
    if (!$start_ts || !$end_ts) return 0;
    $diff = $end_ts - $start_ts;
    if ($diff < 0) return 0;
    return round($diff / 3600, 2);
}

// پارامترهای ورودی فیلتر
$start = $_GET['start'] ?? '';
$end = $_GET['end'] ?? '';
$personnel_code = $_GET['personnel_code'] ?? '';
$filter = [];

// کوئری اصلی: ابتدا فقط رکوردهای جدول attendance را می‌خوانیم
$sql = "SELECT a.*, u.username FROM attendance a LEFT JOIN users u ON a.personnel_code = u.personnel_code WHERE 1=1";

if (!empty($start)) {
    $sql .= " AND a.datetime >= ?";
    $filter[] = $start . " 00:00:00";
}
if (!empty($end)) {
    $sql .= " AND a.datetime <= ?";
    $filter[] = $end . " 23:59:59";
}
if (!empty($personnel_code)) {
    $sql .= " AND a.personnel_code = ?";
    $filter[] = $personnel_code;
}

$stmt = $conn->prepare($sql);
if (!empty($filter)) {
    $types = str_repeat('s', count($filter));
    $stmt->bind_param($types, ...$filter);
}
$stmt->execute();
$result = $stmt->get_result();

$totalHoursByPersonnel = [];
$dataRows = [];

while ($row = $result->fetch_assoc()) {
    $hours = 0;
    if (!empty($row['exit_time'])) {
        $hours = hoursDiff($row['datetime'], $row['exit_time']);
    }
    $code = $row['personnel_code'];
    $totalHoursByPersonnel[$code] = ($totalHoursByPersonnel[$code] ?? 0) + $hours;
    $row['hours'] = $hours;
    $dataRows[] = $row;
}

// خروجی CSV فقط زمانی که export=csv است
if (isset($_GET['export']) && $_GET['export'] === 'csv') {
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename=attendance_report.csv');
    
    $output = fopen('php://output', 'w');
    fputcsv($output, ['ID', 'نام پرسنل', 'تاریخ ورود', 'تاریخ خروج', 'نوع', 'IP', 'دستگاه', 'ساعت کارکرد']);
    
    foreach ($dataRows as $row) {
        fputcsv($output, [
            $row['id'],
            $row['username'] ?? '---',
            toJalali($row['datetime']),
            !empty($row['exit_time']) ? toJalali($row['exit_time']) : '-',
            $row['type'],
            $row['ip_address'],
            $row['device_info'],
            $row['hours']
        ]);
    }
    fclose($output);
    exit;
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>گزارش حضور و غیاب</title>
  <style>
    body {
      font-family: Tahoma, sans-serif;
      background: #f4f4f4;
      padding: 20px;
    }

    h2 {
      text-align: center;
    }

    .filter {
      margin-bottom: 20px;
      text-align: center;
    }

    .filter input, .filter button {
      padding: 6px 10px;
      font-size: 14px;
      margin: 2px;
    }

    .table-container {
      overflow-x: auto;
      background: white;
      border-radius: 10px;
      padding: 10px;
      box-shadow: 0 0 8px rgba(0,0,0,0.1);
      margin-top: 20px;
    }

    table {
      width: 100%;
      border-collapse: collapse;
      min-width: 600px;
    }

    th, td {
      padding: 12px 8px;
      border: 1px solid #ddd;
      text-align: center;
      font-size: 14px;
    }

    th {
      background-color: #007BFF;
      color: white;
    }

    tr:nth-child(even) {
      background-color: #f9f9f9;
    }

    .summary-table {
      max-width: 500px;
      margin: 0 auto 20px auto;
      background: white;
      border-radius: 10px;
      box-shadow: 0 0 8px rgba(0,0,0,0.1);
      overflow: hidden;
    }

    .summary-table table {
      width: 100%;
      border-collapse: collapse;
    }

    .summary-table th {
      background: #28a745;
      color: white;
    }

    .summary-table td, .summary-table th {
      padding: 10px;
      border: 1px solid #ccc;
      font-weight: bold;
      font-size: 16px;
    }

    .summary-table td {
      text-align: center;
    }
  </style>
</head>
<body>

<h2>📋 مجموع ساعت‌های کاری</h2>
<?php if (!empty($totalHoursByPersonnel)): ?>
  <div class="summary-table">
    <table>
      <tbody>
        <tr>
          <td><?= round(array_sum($totalHoursByPersonnel), 2) ?></td>
        </tr>
      </tbody>
    </table>
  </div>
<?php else: ?>
  <p style="text-align:center; font-weight:bold;">مقداری برای مجموع ساعت‌ها یافت نشد.</p>
<?php endif; ?>

<form method="GET" class="filter">
    <label>از تاریخ: <input type="date" name="start" value="<?= htmlspecialchars($start) ?>"></label>
    <label>تا تاریخ: <input type="date" name="end" value="<?= htmlspecialchars($end) ?>"></label>
    <label>کد پرسنلی: <input type="text" name="personnel_code" value="<?= htmlspecialchars($personnel_code) ?>"></label>
    <button type="submit">🔍 جستجو</button>
    <a href="?<?= http_build_query($_GET + ['export' => 'csv']) ?>">📤 خروجی CSV</a>
</form>

<div class="table-container">
<table>
  <thead>
    <tr>
      <th>ID</th>
      <th>نام پرسنل</th>
      <th>تاریخ ورود</th>
      <th>تاریخ خروج</th>
      <th>نوع</th>
      <th>IP</th>
      <th>دستگاه</th>
      <th>ساعت کارکرد</th>
    </tr>
  </thead>
  <tbody>
    <?php if (empty($dataRows)): ?>
      <tr><td colspan="8">📛 داده‌ای برای نمایش وجود ندارد.</td></tr>
    <?php else: ?>
      <?php foreach ($dataRows as $row): ?>
        <tr>
          <td><?= $row['id'] ?></td>
          <td><?= htmlspecialchars($row['username'] ?? '---') ?></td>
          <td><?= toJalali($row['datetime']) ?></td>
          <td><?= !empty($row['exit_time']) ? toJalali($row['exit_time']) : '-' ?></td>
          <td><?= htmlspecialchars($row['type'] ?? '') ?></td>
          <td><?= htmlspecialchars($row['ip_address'] ?? '') ?></td>
          <td><?= htmlspecialchars($row['device_info'] ?? '') ?></td>
          <td><?= $row['hours'] ?></td>
        </tr>
      <?php endforeach; ?>
    <?php endif; ?>
  </tbody>
</table>
</div>

</body>
</html>
