<?php
$host = "localhost";
$user = "kvueikjf_att_user";
$pass = "Mmohammad59!!!";
$dbname = "kvueikjf_attendance_db";

$conn = new mysqli($host, $user, $pass, $dbname);
$conn->set_charset("utf8");

$message = "";
$messageClass = "";

if ($conn->connect_error) {
    die("❌ اتصال به پایگاه داده ناموفق بود: " . $conn->connect_error);
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['personnel_code'])) {
    $code = trim($_POST['personnel_code']);
    $ip = $_SERVER['REMOTE_ADDR'];
    $device = $_SERVER['HTTP_USER_AGENT'];
    $now = date("Y-m-d H:i:s");

    // گرفتن اطلاعات کاربر از جدول users
    $stmt = $conn->prepare("SELECT id, username FROM users WHERE personnel_code = ?");
    if (!$stmt) {
        die("❌ خطا در prepare (کاربر): " . $conn->error);
    }
    $stmt->bind_param("s", $code);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 0) {
        $message = "❌ کاربری با این کد پرسنلی یافت نشد.";
        $messageClass = "error";
    } else {
        $user = $result->fetch_assoc();
        $userId = $user['id'];
        $username = $user['username'];

        // بررسی آخرین ورود بدون خروج
        $stmt = $conn->prepare("SELECT id FROM attendance WHERE personnel_code = ? AND exit_time IS NULL ORDER BY datetime DESC LIMIT 1");
        $stmt->bind_param("s", $code);
        $stmt->execute();
        $res = $stmt->get_result();

        if ($res->num_rows > 0) {
            // ثبت خروج برای رکورد قبلی
            $row = $res->fetch_assoc();
            $entryId = $row['id'];

            $update = $conn->prepare("UPDATE attendance SET exit_time = ? WHERE id = ?");
            $update->bind_param("si", $now, $entryId);
            $update->execute();

            $message = "✅ خروج ثبت شد برای $username";
            $messageClass = "success";
        } else {
            // ثبت ورود جدید
            $type = 'entry';
            $stmt = $conn->prepare("INSERT INTO attendance (personnel_code, datetime, type, ip_address, device_info, user_id) VALUES (?, ?, ?, ?, ?, ?)");
            $stmt->bind_param("sssssi", $code, $now, $type, $ip, $device, $userId);
            $stmt->execute();

            $message = "✅ ورود ثبت شد برای $username";
            $messageClass = "success";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8" />
    <title>ثبت ورود/خروج</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <style>
        @import url('https://cdn.jsdelivr.net/gh/rastikerdar/vazir-font@v30.1.0/dist/font-face.css');

        body {
            font-family: 'Vazir', Tahoma, sans-serif;
            background: linear-gradient(135deg, #a0c4ff, #caf0f8);
            color: #222;
            margin: 0;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .container {
            background: rgba(255, 255, 255, 0.9);
            padding: 30px 40px;
            border-radius: 12px;
            max-width: 400px;
            width: 100%;
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.1);
            text-align: center;
            color: #333;
        }

        h2 {
            margin-bottom: 25px;
            font-weight: 700;
            font-size: 1.8rem;
            letter-spacing: 1.5px;
        }

        label {
            display: block;
            text-align: right;
            font-size: 1rem;
            margin-bottom: 8px;
            color: #555;
        }

        input[type="text"] {
            width: 100%;
            padding: 12px 15px;
            font-size: 1.1rem;
            border-radius: 8px;
            border: 1.8px solid #7ec8e3;
            outline: none;
            margin-bottom: 20px;
            box-sizing: border-box;
            transition: border-color 0.3s ease;
            direction: ltr;
            text-align: left;
        }

        input[type="text"]:focus {
            border-color: #3a96d9;
            box-shadow: 0 0 10px #3a96d9aa;
        }

        button {
            width: 100%;
            padding: 14px;
            font-size: 1.2rem;
            border-radius: 8px;
            border: none;
            background-color: #4fc3f7;
            color: white;
            cursor: pointer;
            font-weight: 700;
            transition: background-color 0.3s ease, box-shadow 0.3s ease;
        }

        button:hover {
            background-color: #0288d1;
            box-shadow: 0 0 15px #0288d1aa;
        }

        .message {
            margin-top: 20px;
            padding: 12px;
            border-radius: 8px;
            font-weight: 600;
            font-size: 1.1rem;
            word-break: break-word;
        }

        .message.success {
            background-color: #c8facc;
            color: #2e7d32;
        }

        .message.error {
            background-color: #ffd6d6;
            color: #b71c1c;
        }

        /* Responsive */
        @media (max-width: 480px) {
            .container {
                padding: 20px;
                max-width: 100%;
            }

            h2 {
                font-size: 1.5rem;
            }

            button, input[type="text"] {
                font-size: 1rem;
                padding: 12px;
            }
        }
    </style>
</head>
<body>
    <div class="container" role="main">
        <h2>ثبت ورود و خروج</h2>
        <form method="post" aria-label="فرم ثبت ورود و خروج">
            <label for="personnel_code">کد پرسنلی:</label>
            <input type="text" id="personnel_code" name="personnel_code" required aria-required="true" autocomplete="off" />
            <button type="submit">ثبت</button>
        </form>
        <?php if($message): ?>
            <div class="message <?= htmlspecialchars($messageClass) ?>" role="alert" aria-live="polite"><?= htmlspecialchars($message) ?></div>
        <?php endif; ?>
    </div>
</body>
</html>
