<?php
// اتصال به پایگاه داده
$host = "localhost";
$user = "root";
$pass = "";
$dbname = "attendance_db";
$conn = new mysqli($host, $user, $pass, $dbname);
if ($conn->connect_error) {
    die("خطا در اتصال به پایگاه داده: " . $conn->connect_error);
}

// دریافت فیلترها
$from = $_GET['from'] ?? '';
$to = $_GET['to'] ?? '';
$name = $_GET['name'] ?? '';

// ساخت شرط‌ها
$where = [];
$params = [];
$types = '';

if (!empty($from) && !empty($to)) {
    $where[] = "a.entry_time BETWEEN ? AND ?";
    $params[] = "$from 00:00:00";
    $params[] = "$to 23:59:59";
    $types .= 'ss';
}

if (!empty($name)) {
    $where[] = "u.name LIKE ?";
    $params[] = "%$name%";
    $types .= 's';
}

$whereClause = count($where) ? 'WHERE ' . implode(' AND ', $where) : '';

// آماده‌سازی کوئری
$sql = "SELECT u.name, a.entry_time, a.exit_time
        FROM attendance a
        JOIN users u ON a.user_id = u.id
        $whereClause
        ORDER BY a.entry_time DESC";

$stmt = $conn->prepare($sql);
if ($types) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();

// تنظیم هدرهای خروجی
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename=report.csv');

// ایجاد خروجی CSV
$output = fopen('php://output', 'w');
fputcsv($output, ['نام کاربر', 'زمان ورود', 'زمان خروج', 'مدت زمان کارکرد']); // سرستون‌ها

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $entry = new DateTime($row['entry_time']);
        $exit = $row['exit_time'] ? new DateTime($row['exit_time']) : null;
        $duration = $exit ? $entry->diff($exit)->format('%h:%i') : '---';
        fputcsv($output, [
            $row['name'],
            $row['entry_time'],
            $row['exit_time'] ?? '---',
            $duration
        ]);
    }
}
fclose($output);
?>
